#!/bin/sh

#
# Script setting proper file permissions and owner
#

exec > /var/log/com.fastviewer.remote/UninstallReport.txt
exec 2>&1

set START_TIME=`date`

echo "----------------------------------------------------------------------------------------"
echo "! Verifying that install package was removed: ${STRAT_TIME}"
echo "----------------------------------------------------------------------------------------"

set -x

PKG_ROOT="$1"
ls -lR "${PKG_ROOT}"

{ set +x; } 2>/dev/null

echo "\n"
echo "----------------------------------------------------------------------------------------"
echo "! Verifying that .plist Files for agents an daemons were removed"
echo "----------------------------------------------------------------------------------------"

set -x

ls -la /Library/LaunchDaemons/com.fastviewer.remote*
ls -la /Library/LaunchAgents/com.fastviewer.remote*

{ set +x; } 2>/dev/null


echo "\n"
echo "----------------------------------------------------------------------------------------"
echo "! Verifying that Priviledged Helper Tools were removed"
echo "----------------------------------------------------------------------------------------"

set -x

ls -la /Library/PrivilegedHelperTools/com.fastviewer.remote*

{ set +x; } 2>/dev/null


echo "\n"
echo "----------------------------------------------------------------------------------------"
echo "! Checking if RemoteService or Agents sre still running"
echo "----------------------------------------------------------------------------------------"

set -x

tccutil reset All com.fastviewer.FastREClient
tccutil reset All com.fastviewer.remote.FvwPreLoginAgent
tccutil reset All com.fastviewer.remote.FvwGUIAgent

ps -ef | grep Fvw

