#!/bin/sh

#
# Script setting proper file permissions and owner
#

exec > /var/log/com.fastviewer.remote/PostInstall.txt
exec 2>&1

set -x

PKG_ROOT="$1"

if ! [ -d "${PKG_ROOT}/registry" ] ; then
echo "Invalid installation root directory: ${PKG_ROOT}"
exit -1
fi

cd  "${PKG_ROOT}"

#set owner and group to root:wheel
chown -R 0:0 "${PKG_ROOT}"

# Make sure that contents of all directories are visible
find . -type d -exec chmod u=rwx,og+rx {} \;

#Make sure that all MacOS binaries are executable
find . -name MacOS -exec chmod -R u=rwx,og+rx {} \;

#make all files readable and config files writable
chmod    0777 "${PKG_ROOT}" "${PKG_ROOT}/config" "${PKG_ROOT}/registry" "${PKG_ROOT}/tools"
chmod    0755 "${PKG_ROOT}/bin" "${PKG_ROOT}/backups"

chmod -R a+r   "${PKG_ROOT}"

find "${PKG_ROOT}/config"   -type f -exec chmod 666 {} \;
find "${PKG_ROOT}/registry" -type f -exec chmod 666 {} \;

